// === KONFIGURATION ===
const FORM_ENABLED = false; // true = formular aktiv, false = direkte omdirigering

// === VÆRKTØJER ===
const $e = i => document.getElementById(i);
const $a = s => document.querySelectorAll(s);
const getClickId = () => (new URLSearchParams(location.search)).get('rtkcid') || null;

// === GLOBAL VARIABEL FOR VALGT TILBUD ===
let SELECTED_OFFER = 1;

// === API BACKEND HJÆLPER ===
async function saveToBackend(data) {
  try {
    const response = await fetch('/save-lead.php', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(data)
    });
    
    const result = await response.json();
    
    if (result.success) {
      console.log('✅ Lead gemt');
      return true;
    } else {
      console.error('❌ Fejl:', result.error);
      return false;
    }
  } catch (error) {
    console.error('❌ Netværksfejl:', error);
    return false;
  }
}

// === GEM ===
class S {
  constructor() { this.k = 'shipping_form_data'; this.e = 'shipping_form_expire' }
  save(d) { try { localStorage.setItem(this.k, JSON.stringify(d)); localStorage.setItem(this.e, Date.now() + 864e5) } catch {} }
  load() { try { return Date.now() > +localStorage.getItem(this.e) ? (this.clear(), null) : JSON.parse(localStorage.getItem(this.k)) } catch { return this.clear(), null } }
  clear() { try { localStorage.removeItem(this.k); localStorage.removeItem(this.e) } catch {} }
  saveField(f, v) { const d = this.load() || {}; d[f] = v; this.save(d) }
}

// === VALIDERING ===
function V(f, v, o) {
  const bl = ['test', 'user', 'fake', 'admin', 'demo'];
  if (f[0] === 'f' || f[0] === 'l') {
    const t = v.trim();
    return !t ? { valid: 0, message: 'Dette felt er påkrævet' } :
           t.length < 3 ? { valid: 0, message: 'Minimum 3 bogstaver' } :
           /\s/.test(t) ? { valid: 0, message: 'Ingen mellemrum' } :
           /[^A-Za-zÀ-ÖØ-öø-ÿ\-]/.test(t) ? { valid: 0, message: 'Kun bogstaver' } :
           bl.some(w => t.toLowerCase().includes(w)) ? { valid: 0, message: 'Navn forbudt' } :
           o && t.toLowerCase() === o.toLowerCase() ? { valid: 0, message: 'Identiske navne' } :
           { valid: 1, message: 'Gyldig' };
  }
  if (f === 'phone') {
    const c = v.replace(/\D/g, '');
    return !c || c.length !== 8 || !/^\d{8}$/.test(c) ? { valid: 0, message: '8 cifre påkrævet' } : { valid: 1, message: 'Gyldig' };
  }
  if (f === 'email') return !v || !/^[\w-.]+@[\w-]+\.[a-z]{2,}$/i.test(v) ? { valid: 0, message: 'Ugyldig e-mail' } : { valid: 1, message: 'Gyldig' };
  if (f === 'zip') return !/^\d{4}$/.test(v) ? { valid: 0, message: 'Ugyldigt postnummer' } : { valid: 1, message: 'Gyldig' };
  if (f === 'city') return v.trim().length < 3 ? { valid: 0, message: 'For kort' } : { valid: 1, message: 'Gyldig' };
  if (f === 'address') { const a = v.trim(); return a.length < 6 ? { valid: 0, message: 'For kort' } : !/\d/.test(a) ? { valid: 0, message: 'Nummer mangler' } : { valid: 1, message: 'Gyldig' } }
  return { valid: 1, message: 'Gyldig' };
}

function U(i, valid, msg = '') {
  i.classList.remove('valid-field', 'invalid-field');
  i.classList.add(valid ? 'valid-field' : 'invalid-field');
  let e = i.id === 'phone-dk' ? i.parentNode.parentNode.querySelector('.error-message') : i.nextElementSibling;
  if (!e?.classList.contains('error-message')) {
    e = document.createElement('div');
    e.className = 'error-message';
    e.style.cssText = 'color:#F95154;font-size:0.875rem;margin-top:4px;display:none;';
    (i.id === 'phone-dk' ? i.parentNode.parentNode : i.parentNode).appendChild(e);
  }
  e.textContent = valid ? '' : msg;
  e.style.display = valid ? 'none' : 'block';
}

// === SLIDER ===
function generateSliderImages() {
  const img = (s, i, m) => `<div class='swiper-slide${m === 'thumbs' ? ' !w-20 !h-20' : ''}'><img src='${s}' class='object-${m === 'contain' ? 'contain' : 'cover'} w-full h-full${m === 'thumbs' ? ' rounded-xl border-2 cursor-pointer' : ''}' alt='Produkt' width='${m === 'thumbs' ? '80' : '500'}' height='${m === 'thumbs' ? '80' : '250'}' loading="${i === 0 && m !== 'thumbs' ? 'eager' : 'lazy'}"></div>`;
  const m = $e('slider-mobile-wrapper-js'), d = $e('slider-desktop-wrapper-js'), t = $e('slider-thumbs-wrapper-js');
  if (m) m.innerHTML = sliderImages.map((s, i) => img(s, i, 'cover')).join('');
  if (d) d.innerHTML = sliderImages.map((s, i) => img(s, i, 'contain')).join('');
  if (t) t.innerHTML = sliderImages.map((s, i) => img(s, i, 'thumbs')).join('');
}

function initSwiper() {
  const thumbs = new Swiper('.thumbs-swiper', { slidesPerView: 5, spaceBetween: 10, slideToClickedSlide: true, breakpoints: { 0: { slidesPerView: 3 }, 480: { slidesPerView: 4 }, 640: { slidesPerView: 5 } } });
  const main = new Swiper('.main-swiper', { loop: true, spaceBetween: 4, speed: 400, simulateTouch: true, grabCursor: true, pagination: { el: '.swiper-pagination', clickable: true, dynamicBullets: true }, thumbs: { swiper: window.innerWidth >= 1024 ? thumbs : null } });
  if (window.innerWidth >= 1024) $a('.thumbs-swiper .swiper-slide').forEach((s, i) => { s.onclick = e => { e.preventDefault(); main.slideToLoop(i) } });
}

// === TILBUD ===
class O {
  constructor() { 
    this.options = $a('.option'); 
    this.buyBtn = $e('buy-btn-section'); 
    this.selectedOffer = this.getDefaultOffer(); 
    SELECTED_OFFER = this.selectedOffer; // Synkroniserer øjeblikkeligt
    this.init() 
  }
  
  getDefaultOffer() {
    const visibleOptions = [...this.options].filter(option => {
      const style = window.getComputedStyle(option);
      return style.display !== 'none' && style.visibility !== 'hidden';
    });
    const optionCount = visibleOptions.length;
    
    if (optionCount === 0) return 1;
    if (optionCount === 1) return 1;
    if (optionCount === 2) return 2;
    if (optionCount >= 3) return 2;
    
    return 1;
  }
  
  init() {
    if (this.options.length === 0) {
      SELECTED_OFFER = this.selectedOffer; // Synkroniserer ved init
      this.updateBuyButton();
      return;
    }
    
    if (![...this.options].some(o => o.classList.contains('border-[#D35400]')) && this.options[1]) this.selectOption(this.options[1], 1);
    this.options.forEach((o, i) => { o.onclick = e => { e.preventDefault(); this.selectOption(o, i) } });
    SELECTED_OFFER = this.selectedOffer; // Synkroniserer efter init
    this.updateBuyButton();
  }
  
  selectOption(o, i) {
    $a('.option').forEach(opt => { opt.classList.remove('border-[#D35400]', 'bg-[#FF71621F]', 'border-4'); opt.style.cssText = '' });
    o.classList.add('border-[#D35400]', 'bg-[#FF71621F]', 'border-4');
    o.style.cssText = 'transition:transform 0.18s;transform:scale(1.045);box-shadow:0 0 0 4px #FFD9C1;';
    setTimeout(() => { o.style.transform = 'scale(1)'; o.style.boxShadow = 'none' }, 180);
    this.selectedOffer = i + 1;
    SELECTED_OFFER = i + 1; // Synkroniserer med global variabel
    this.updateBuyButton();
  }
  
  updateBuyButton() {
    if (!this.buyBtn) return;
    let url = this.buyBtn.getAttribute('data-base-url') || '';
    if (url) {
      url = url.replace(/(\/click\/)[0-9]+/, `$1${this.selectedOffer}`);
      const u = new URL(url);
      u.searchParams.set('sub17', `${location.origin}/img/logo.png`);
      const s = u.searchParams.get('sub19') || '';
      u.searchParams.set('sub19', `${this.selectedOffer}x ${s.replace(/^[123]x\s+/, '')}`);
      this.buyBtn.setAttribute('href', u.toString());
    }
  }
}

// === MODAL ===
class M {
  constructor() { 
    this.modal = $e('shipping-modal'); 
    this.buyBtn = $e('buy-btn-section'); 
    this.form = $e('shipping-form'); 
    this.storage = new S(); 
    this.body = document.body;
    this.init();
  }
  
  toggleModalScrolling(isOpen) {
    if (window.innerWidth <= 768) {
      if (isOpen) {
        this.body.style.overflow = 'hidden';
        this.body.style.position = 'fixed';
        this.body.style.width = '100%';
        this.body.setAttribute('aria-modal-open', 'true');
      } else {
        this.body.style.overflow = '';
        this.body.style.position = '';
        this.body.style.width = '';
        this.body.removeAttribute('aria-modal-open');
      }
    }
  }
  
  init() {
    if (this.buyBtn) this.buyBtn.onclick = e => { 
      e.preventDefault(); 
      if (FORM_ENABLED) {
        this.open();
      } else {
        // Standby-tilstand: direkte omdirigering
        const url = this.buyBtn.getAttribute('href');
        if (url) {
          window.location.href = url;
        }
      }
    };
    if ($e('close-shipping-modal')) $e('close-shipping-modal').onclick = () => this.close();
    if (this.modal) { 
      this.modal.onclick = e => { 
        if (e.target === this.modal) this.close() 
      }; 
      this.modal.style.display = 'none';
    }
    if (this.form && FORM_ENABLED) this.form.onsubmit = e => this.handleSubmit(e);
    if (FORM_ENABLED) { this.initValidation(); this.setupRealtimeValidation(); this.setupAutoSave(); }
  }

  loadSavedData() {
    if (!FORM_ENABLED) return;
    const saved = this.storage.load();
    if (!saved) return;
    const fields = { 'first-name': 'firstName', 'last-name': 'lastName', 'address-autocomplete': 'address', 'zip-autocomplete': 'zip', 'city-autocomplete': 'city', 'phone-dk': 'phone', 'email-autocomplete': 'email' };
    Object.entries(fields).forEach(([id, field]) => {
      const input = $e(id);
      if (input && saved[field]) {
        input.value = saved[field];
        setTimeout(() => {
          const other = field === 'firstName' ? saved.lastName : field === 'lastName' ? saved.firstName : '';
          const { valid, message } = V(field, saved[field], other);
          U(input, valid, message);
        }, 100);
      }
    });
  }

  setupAutoSave() {
    if (!FORM_ENABLED) return;
    const fields = { 'first-name': 'firstName', 'last-name': 'lastName', 'address-autocomplete': 'address', 'zip-autocomplete': 'zip', 'city-autocomplete': 'city', 'phone-dk': 'phone', 'email-autocomplete': 'email' };
    Object.entries(fields).forEach(([id, field]) => {
      const input = $e(id);
      if (input) ['input', 'blur'].forEach(evt => { input.addEventListener(evt, () => this.storage.saveField(field, input.value)) });
    });
  }

  setupRealtimeValidation() {
    if (!FORM_ENABLED) return;
    const validate = (id, field) => {
      const input = $e(id);
      if (input) input.addEventListener('blur', () => {
        const other = field === 'firstName' ? $e('last-name')?.value : field === 'lastName' ? $e('first-name')?.value : '';
        const { valid, message } = V(field, input.value, other);
        U(input, valid, message);
      });
    };
    [['first-name', 'firstName'], ['last-name', 'lastName'], ['email-autocomplete', 'email'], ['phone-dk', 'phone'], ['address-autocomplete', 'address'], ['zip-autocomplete', 'zip'], ['city-autocomplete', 'city']].forEach(([id, field]) => validate(id, field));
    const zip = $e('zip-autocomplete');
    if (zip) zip.addEventListener('input', e => { e.target.value = e.target.value.replace(/\D/g, '').slice(0, 4) });
  }

  async handleSubmit(e) {
    e.preventDefault();
    const data = Object.fromEntries(new FormData(this.form).entries());
    const validations = { email: V('email', data.email), phone: V('phone', data.phone), address: V('address', data.address), firstName: V('firstName', data.firstName, data.lastName), lastName: V('lastName', data.lastName, data.firstName), zip: V('zip', data.zip), city: V('city', data.city) };
    if (!Object.values(validations).every(v => v.valid)) {
      alert('⚠️ Ret venligst de røde felter');
      Object.entries(validations).forEach(([field, result]) => {
        if (!result.valid) {
          const inputId = field === 'firstName' ? 'first-name' : field === 'lastName' ? 'last-name' : field === 'phone' ? 'phone-dk' : field + '-autocomplete';
          U($e(inputId), false, result.message);
        }
      });
      return;
    }
    
    const clickId = getClickId();
    let phone = data.phone || '';
    if (phone) { phone = phone.replace(/\D/g, ''); phone = '+45' + phone }
    
    const apiData = {
      click_id: clickId,
      first_name: data.firstName,
      last_name: data.lastName,
      email: data.email,
      phone: phone,
      address: data.address,
      zip: data.zip,
      city: data.city,
      country: 'Danmark',
      offer_selected: SELECTED_OFFER
    };
    
    this.storage.save(data);
    const saved = await saveToBackend(apiData);
    
    if (!saved) {
      alert('❌ Teknisk problem. Prøv igen.');
      return;
    }
    
    const url = this.buyBtn?.getAttribute('href');
    if (url) {
      location.href = this.buildPrefillUrl(url, data);
    } else {
      this.close();
    }
  }
  
  getSelectedOffer() {
    return SELECTED_OFFER;
  }

  buildPrefillUrl(baseUrl, data) {
    if (!/^https?:\/\//.test(baseUrl)) baseUrl = 'https://' + baseUrl.replace(/^\/+/, '');
    let url; try { url = new URL(baseUrl) } catch { return baseUrl }
    let phone = data.phone || '';
    if (phone) { phone = phone.replace(/\D/g, ''); phone = '+45' + phone }
    const clickId = getClickId();
    const mapping = { sub9: data.firstName || '', sub10: data.lastName || '', sub11: data.email || '', sub12: phone, sub13: data.address || '', sub14: data.zip || '', sub15: data.city || '', sub16: 'Danmark' };
    Object.entries(mapping).forEach(([k, v]) => url.searchParams.set(k, v));
    return url.toString();
  }

  open() {
    if (!FORM_ENABLED) return;
    if (!this.modal) return;
    this.modal.style.display = 'flex'; 
    this.modal.setAttribute('aria-visible', 'true'); 
    this.loadSavedData();
    this.toggleModalScrolling(true);
  }

  close() {
    if (!this.modal) return;
    this.modal.setAttribute('aria-visible', 'false');
    this.toggleModalScrolling(false);
    setTimeout(() => this.modal.style.display = 'none', 300);
  }

  initValidation() {
    if (!FORM_ENABLED) return;
    const phone = $e('phone-dk');
    if (phone) {
      phone.oninput = e => e.target.value = e.target.value.replace(/\D/g, '').slice(0, 8);
      phone.onblur = e => { const v = e.target.value.replace(/\D/g, ''); if (v.length === 8) e.target.value = v.replace(/(\d{2})(\d{2})(\d{2})(\d{2})/, '$1 $2 $3 $4') };
    }
  }
}

// === COUNTDOWN ===
class C {
  constructor() { this.timer = $e('timer2'); if (this.timer) this.start() }
  start() {
    let t = 60, c = 0;
    const tick = setInterval(() => {
      this.timer.innerText = --t;
      if (t <= 0) { clearInterval(tick); if (++c < 22) { t = 60; this.start() } }
    }, 1000);
  }
}

// === DATOER ===
class D {
  constructor() {
    const today = new Date(), fmt = d => new Intl.DateTimeFormat('da-DK', { weekday: 'short', day: 'numeric', month: 'short' }).format(d);
    const ship = new Date(today.getTime() + 864e5); // Shipping: næste dag
    const deliv = new Date(today.getTime() + 2592e5); // Levering: 3 dage fra i dag
    if ($e('currentDate')) $e('currentDate').innerText = fmt(today);
    if ($e('shippedDate')) $e('shippedDate').innerText = fmt(ship);
    if ($e('deliveryDate')) $e('deliveryDate').innerText = fmt(deliv);
  }
}

// === LAGER ===
class B {
  constructor(mobile) {
    this.bar = $e(mobile ? 'progressBar' : 'progressBar-desktop'); this.text = $e(mobile ? 'stockPercent' : 'stockPercent-desktop');
    if (this.bar && this.text && ((mobile && window.innerWidth < 1024) || (!mobile && window.innerWidth >= 1024))) this.animate();
  }
  animate() {
    let start = null;
    const frame = t => {
      if (!start) start = t;
      const p = Math.min((t - start) / 48e4, 1), cur = Math.round(28 - (27 * p));
      this.bar.style.width = cur + '%'; this.text.textContent = cur + '% af lageret tilbage';
      this.bar.className = this.bar.className.replace(/bg-\[#[^\]]+\]/g, '') + (cur > 21 ? ' bg-[#F95154]' : ' bg-[#FF9900]');
      if (p < 1 && cur > 1) requestAnimationFrame(frame);
    };
    requestAnimationFrame(frame);
  }
}

// === STICKY ===
class T {
  constructor() { this.sticky = $e('sticky-cta'); this.buy = $e('buy-btn-section'); if (this.sticky) this.sticky.style.display = 'none'; this.init() }
  init() {
    const check = () => { if (!this.sticky || !this.buy) return; this.sticky.style.display = this.buy.getBoundingClientRect().bottom <= 0 ? 'flex' : 'none' };
    const layout = () => {
      if (!this.sticky) return;
      if (window.innerWidth >= 1024) {
        const l = document.querySelector('.slider-col'), r = document.querySelector('.content-col');
        if (l && r) { const w = Math.max(l.offsetWidth, r.offsetWidth); this.sticky.style.cssText = this.sticky.style.cssText.replace(/width:[^;]*;?|left:[^;]*;?|transform:[^;]*;?|max-width:[^;]*;?/g, '') + `width:${w}px;left:50%;transform:translateX(-50%);max-width:${w}px;` }
      } else { this.sticky.style.cssText = this.sticky.style.cssText.replace(/width:[^;]*;?|left:[^;]*;?|transform:[^;]*;?|max-width:[^;]*;?/g, '') + 'left:0;right:0;width:100%;transform:none;' }
    };
    window.addEventListener('scroll', check); window.addEventListener('resize', () => { check(); layout() }); check(); layout();
  }
}

// === INIT ===
document.addEventListener('DOMContentLoaded', () => {
  if (typeof sliderImages !== 'undefined') { generateSliderImages(); initSwiper() }
  new O(); new M(); new C(); new D(); new B(true); new B(false); new T();
});